function h = plotDegree(obj,varargin)
%PLOTDEGREE Plot the degree of an AdjacencyMatrix object
%   Optional parameters:
%       'degreeType' - should be 'in', 'out', or 'total'.  Default is
%           'total'.  Determines the type of degree to be fit (in-degree,
%           out-degree, or total degree)
%       'weighted' - should be true or false.  Determines whether edge
%           weights are considered.  Default is true.
%       'threshold' - if 'weighted' is set to false, then the
%           tolerance will determine the lower limit for the weight of an
%           edge. Default is 1.  Set to a higher number to eliminate noise;
%           spurious edges.


weighted = true;
degreeType = 'total';
tolerance = 1;
nBins = 0;


for k = 1:2:length(varargin)
    switch varargin{k}
        case 'degreeType'
            degreeType = varargin{k+1};
        case 'threshold'
            tolerance = varargin{k+1};
        case 'weighted'
            weighted = varargin{k+1};
        case 'nBins'
            nBins = varargin{k+1};
    end
end

switch weighted
    case true
        A = obj.A;
    case false
        A = obj.A;
        A = double(A>= tolerance);
end


switch degreeType
    case 'in'
        x = sum(A,1);
    case 'out'
        x = sum(A,2);
    case 'total'
        switch weighted
            case true
                A = getSquareMatrix(obj);
                colSums = sum(A,1);
                rowSums = sum(A,2);
                x = rowSums + colSums';
            case false
                A = getSquareMatrix(obj);
                A = double(A >= tolerance);
                colSums = sum(A,1);
                rowSums = sum(A,2);
                x = rowSums + colSums';
        end
end

% Plot Histogram
figure;
dataLabels = 'bo';
D = unique(x);
if nBins == 0
    hts = hist(x,D);
else
    [hts D] = hist(x,nBins);
    
end

h = bar(D,hts);
xlabel('Degree');
ylabel('Number of nodes');
axis([-.5 max(D)+.5 0 max(hts)]);
set(gcf,'Color',[1 1 1]);

end

